<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if( Schema::hasTable('gsts') ) {
        Schema::create('gsts', function (Blueprint $table) {
            $table->id();
            $table->boolean('gst_enable')->default(0); // tinyint(1)
            $table->string('gst_number', 121)->nullable();
            $table->string('company_name', 121)->nullable();
            $table->string('address', 121)->nullable();
            $table->string('gst_per', 121)->nullable(); // Consider changing to decimal if numeric
            $table->timestamps(); // created_at & updated_at
        });
    }
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
